\ =============
\ DUMPPEH.4TH
\ Das Programm
\ =============

DECIMAL

\ Die hier definierten Worte werden vorwiegend sofort ausgefuehrt.

warning off        \ nicht für Bigforth           
marker dumpmarker  \ Wegen den Redefinitionen, am Ende alles 'vergessen'.

\ ------------------------------------------------------------------------------
\ Kommentar über mehreren Zeilen für Bigforth.

: (( ( -- )
   BEGIN
     bl word dup @
     [ hex ffffff decimal ] literal and
     [ hex 292902 decimal ] literal <>
   WHILE
     c@ 0= IF refill drop THEN
   REPEAT
   drop
; immediate

\ ------------------------------------------------------------------------------
\ Definition der Strukturworte.

: structur
   CREATE here 0 , 0    \ ( "bname" -- dfa ofs=0 )
   DOES>  @             \ ( dfa -- nbytes )
   CREATE allot         \ ( "sname" nbytes -- )
;

: field                 \ ( "fname" ofs field.dfa -- ofs+fsize )
   CREATE over , +
   DOES> @ +            \ ( base dfa -- base+ofs )
;

: endstructur           \ ( dfa nbytes -- )
   swap !
;

\ ------------------------------------------------------------------------------
\ Redefinition der Strukturworte.

24 CONSTANT ntab      \ Tabulatorwert
0  VALUE fval         \ Aktueller Feld-Wert
0  VALUE ofsh         \ laufender Offset beim einlesen
0  VALUE defflag      \ -1 bei Redefinitionen

\ Konversion.
: >fstring ( string0 -- str len )
   0 BEGIN 2dup + c@ WHILE 1+ REPEAT
;

\ Sektionname ausgeben.
: .section_name ( string0 -- )
   >fstring 8 min 8 over - spaces type
;

\ Strukturname anzeigen.
: structur2 ( ccc<*> -- ) cr cr bl word count type ;

\ Feldwert in hex ausgeben, Sektion-Name ausgeben.
: field2 ( size -- )
   base @ swap hex
   bl word count dup >r cr type
   ntab r> - spaces
   ( size ) dup
   CASE
     1 OF  ofsh c@ dup to fval 8 u.r  ENDOF
     2 OF  ofsh w@ dup to fval 8 u.r  ENDOF
     4 OF  ofsh  @ dup to fval 8 u.r  ENDOF
     8 OF  ofsh .section_name         ENDOF
   DUP OF  8 spaces                   ENDOF
   ENDCASE
   2 spaces
   ( size ) ofsh + to ofsh
   base !
;

: endstructur2 ( -- )  noop ;

\ Sektion-Attribute anzeigen.
: attribute ( -- )
   [ hex ]
   fval 20000000 and IF  ." ausfuehren "  THEN
   fval 40000000 and IF  ." lesen "       THEN
   fval 80000000 and IF  ." schreiben "   THEN
   [ decimal ]
;

: rem ( -- ) source >in ! drop ;

\ Steuerung der Strukturworte, bedingtes Kommentarwort.
: structur     defflag IF structur2    ELSE structur    THEN ;
: field        defflag IF field2       ELSE field       THEN ;
: endstructur  defflag IF endstructur2 ELSE endstructur THEN ;
: \?           defflag IF noop         ELSE rem         THEN ;

\ Zum gezieltes 'include' der Strukturen, werden diese Worte spaeter mit
\ 'noop' oder 'rem' belegt.
DEFER doshdr
DEFER pehdr
DEFER sectionhdr
DEFER importhdr

\ ------------------------------------------------------------------------------
\ Struktur-Prototypen anlegen, Windows-Header laden und Zeiger setzen.

24   CONSTANT ntfile_size
40   CONSTANT section_size
1000 CONSTANT header_size    \ Programmkopf-Groesse
\
\ Basis der Strukturen
0 VALUE dos{}
0 VALUE ntfile{}
0 VALUE optional{}
0 VALUE section0{}
\
0 VALUE  peheader   \ vorhanden ( -1 )
0 VALUE  #section   \ Anzahl der Sektionen
0 VALUE  fid        \ Datei-Kennung

CREATE basepage header_size chars allot  \ Buffer

\ Fehlermeldungen.
: dumpend1 ( -- ) cr ." Datei nicht vorhanden" dumpmarker abort ;
: dumpend2 ( -- ) cr ." Kein Windows-Header vorhanden" dumpmarker abort ;

\ Kontrolle.
: ?openerror ( n -- )          IF  dumpend1  THEN ;
: ?winheader ( n -- ) $5a4d <> IF  dumpend2  THEN ;
: ?peheader  ( n -- ) $4550 <> IF  dumpend2  THEN ;

\ Struktur-Definition aktivieren.
\ alle Strukturen anlegen.
0 to defflag
' rem is doshdr
' rem is pehdr
' rem is sectionhdr
' rem is importhdr

\ Struktur-Prototypen anlegen.
includepath_pe INCLUDED

: windows_header_laden ( -- )
   path\name count r/o OPEN-FILE ?openerror to fid
   basepage header_size fid READ-FILE 2drop
   basepage to dos{}
   dos{} e_magic w@ ?winheader                  \ 'MZ' ?
   dos{} e_lfanew @ ( ofs )                     \ NTFILE_HEADER-Offset
   dup $100 u<
   IF
      ( ofs ) dos{} + to ntfile{}               \ NTFILE_HEADER-Basis
      ntfile{} Signature @ ?peheader            \ 'PE' ?
      -1 to peheader
      ntfile{} NumberOfSections w@ to #section  \ Anzahl der Sektionen
      ntfile{} ntfile_size + to optional{}      \ OPTIONAL_HEADER-Basis
      ntfile{} SizeOfOptionalHeader w@          \ OPTIONAL_HEADER-Laenge
      optional{} + to section0{}                \ SECTION_HEADER-Basis
   ELSE
      drop                                      \ DOS-Header
   THEN
;

windows_header_laden

\ ------------------------------------------------------------------------------
\ Strukturen mit redefinierten Worten nochmal laden. Sie werden jetzt angezeigt.

\ Index nach Adresse transformieren.
: section{} ( i -- adr ) section_size * section0{} + ;

\ Windows-Header anzeigen.
: .winheader ( -- )
   page
   -1 to defflag                  \ Struktur-Redefinition aktivieren
   peheader
   IF                             \ pe_header anzeigen
      ntfile{} to ofsh
      ['] rem  is pehdr
      ['] noop is doshdr
      ['] noop is sectionhdr
      ['] noop is importhdr
     includepath_pe INCLUDED
   ELSE                           \ dos_header anzeigen
      dos{} to ofsh
      ['] rem  is doshdr
      ['] noop is pehdr
      ['] noop is sectionhdr
      ['] noop is importhdr
      includepath_pe INCLUDED
      dumpmarker quit             \ Ende
   THEN
;

\ Sektionen anzeigen.
: .sections ( -- )
   peheader
   IF                             \ section_header anzeigen
      ['] rem  is sectionhdr
      ['] noop is pehdr
      ['] noop is doshdr
      ['] noop is importhdr
      #section 0
      DO
         i section{} to ofsh
         includepath_pe INCLUDED
      LOOP
   THEN
;

.winheader
.sections

\ ------------------------------------------------------------------------------
\ Sektion suchen, wo die Import-Funktionen liegen.

0 VALUE virtual_size      \ VirtualSize
0 VALUE virtual_address   \ VirtualAddress
0 VALUE raw_size          \ SizeOfRawData
0 VALUE raw_pointer       \ PointerToRawData

\ Die Adresse ImportDirectoryRva @ (Eintrag vom OPTIONAL_HEADER) muss zwischen
\ VirtualAddress und VirtualAddress+VirtualSize der Sektion liegen.

: search_importsection ( -- )
   #section 0
   DO
      i section{}
      dup SizeOfRawData @ to raw_size
      dup PointerToRawData @ to raw_pointer
      dup VirtualAddress @ to virtual_address
      dup VirtualSize @ to virtual_size
      drop
      optional{} ImportDirectoryRva @
      virtual_address dup virtual_size + WITHIN IF leave THEN
   LOOP
;

search_importsection  \ Virtualaddress (Offset)

\ ------------------------------------------------------------------------------
\ Import-Funktionen anzeigen.
\
\ Die IMPORT_DESCRIPTOREN bilden ein Array von Strukturen.
\ Die letzte ist eine Struktur mit lauter Nullen.

CREATE importsection{} raw_size chars allot   \ Array von IMPORT_DESCRIPTOREN

0  VALUE import0{}       \ 1. IMPORT_DESCRIPTOR
20 CONSTANT importsize   \ Länge

\ Weitere IMPORT_DESCRIPTOREN.
: import{} ( i -- adr ) importsize * import0{} + ;

\ Offset nach absolute Adresse transformieren.
: ofs>mem ( offset -- mem_adr )
   virtual_address - importsection{} +
;

\ Importsection laden und Zeiger setzen
: importsektion_laden ( -- )
   raw_pointer s>d fid REPOSITION-FILE drop
   importsection{} raw_size fid READ-FILE 2drop
   fid CLOSE-FILE drop
   optional{} ImportDirectoryRva @ ofs>mem to import0{}
;

\ Import-Funktinen anzeigen.
: .import ( -- )
   base @ hex
   10 0 DO
     cr
     i import{} DllName @ dup 0<>
     IF
       ( Name der dll-Datei anzeigen )
       cr ." IMPORTIERTE FUNKTIONEN AUS " ofs>mem >fstring type
       i import{} PointerToThunkData @
       BEGIN
         dup ofs>mem @ dup 0<>
       WHILE
         ( Nummer und Name der Funktionen anzeigen )
         dup ofs>mem w@ cr 4 .r space
         2 + ofs>mem >fstring type
         4 +
       REPEAT
       2drop
     ELSE
       drop leave
     THEN
   LOOP
   base !
   cr
;

importsektion_laden
.import

dumpmarker  \ alles 'vergessen'
